%------------------------------------------------------------------------------
% File     : ITP169^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Safety_Regular problem prob_273__3352790_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Safety_Regular/prob_273__3352790_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v7.5.0
% Syntax   : Number of formulae    :  333 ( 104 unt;  54 typ;   0 def)
%            Number of atoms       : 1022 ( 483 equ;   0 cnn)
%            Maximal formula atoms :   17 (   3 avg)
%            Number of connectives : 5544 (  62   ~;  38   |; 434   &;4772   @)
%                                         (   0 <=>; 238  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   24 (   8 avg)
%            Number of types       :    8 (   7 usr)
%            Number of type conns  :  142 ( 142   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   48 (  47 usr;   9 con; 0-4 aty)
%            Number of variables   :  962 (  10   ^; 772   !; 158   ?; 962   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:22:47.514
%------------------------------------------------------------------------------
% Could-be-implicit typings (8)
thf(ty_t_Views_Oview_Oview__ext,type,
    view_ext: $tType > $tType ).

thf(ty_t_Product__Type_Ounit,type,
    product_unit: $tType ).

thf(ty_t_RealInt_Oreal__int,type,
    real_int: $tType ).

thf(ty_t_Traffic_Otraffic,type,
    traffic: $tType ).

thf(ty_t_NatInt_Onat__int,type,
    nat_int: $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Cars_Ocars,type,
    cars: $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

% Explicit typings (46)
thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ostrict__ordered__ab__semigroup__add,type,
    strict2144017051up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__semigroup__monoid__add__imp__le,type,
    ordere516151231imp_le: 
      !>[A: $tType] : $o ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Length_Osensors_Olen,type,
    len: ( cars > traffic > cars > real ) > ( view_ext @ product_unit ) > traffic > cars > real_int ).

thf(sy_c_Move_Otraffic_Omove,type,
    move: traffic > traffic > ( view_ext @ product_unit ) > ( view_ext @ product_unit ) ).

thf(sy_c_NatInt_Onat__int_Ocard_H,type,
    nat_card: nat_int > nat ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_RealInt_Oreal__int_Olength,type,
    real_length: real_int > real ).

thf(sy_c_Regular__Sensors_Oregular,type,
    regular_regular: cars > traffic > cars > real ).

thf(sy_c_Restriction_Orestriction_Orestrict,type,
    restrict: ( view_ext @ product_unit ) > ( cars > nat_int ) > cars > nat_int ).

thf(sy_c_Traffic_Otraffic_Oabstract,type,
    abstract: traffic > traffic > $o ).

thf(sy_c_Traffic_Otraffic_Oclm,type,
    clm: traffic > cars > nat_int ).

thf(sy_c_Traffic_Otraffic_Ocreate__claim,type,
    create_claim: traffic > cars > nat > traffic > $o ).

thf(sy_c_Traffic_Otraffic_Ocreate__reservation,type,
    create_reservation: traffic > cars > traffic > $o ).

thf(sy_c_Traffic_Otraffic_Ores,type,
    res: traffic > cars > nat_int ).

thf(sy_c_Traffic_Otraffic_Owithdraw__claim,type,
    withdraw_claim: traffic > cars > traffic > $o ).

thf(sy_c_Traffic_Otraffic_Owithdraw__reservation,type,
    withdraw_reservation: traffic > cars > nat > traffic > $o ).

thf(sy_c_Views_Oview_Oext,type,
    ext: 
      !>[Z: $tType] : ( ( view_ext @ Z ) > real_int ) ).

thf(sy_c_Views_Oview_Ohchop,type,
    hchop: ( view_ext @ product_unit ) > ( view_ext @ product_unit ) > ( view_ext @ product_unit ) > $o ).

thf(sy_c_Views_Oview_Olan,type,
    lan: 
      !>[Z: $tType] : ( ( view_ext @ Z ) > nat_int ) ).

thf(sy_c_Views_Oview_Oown,type,
    own: 
      !>[Z: $tType] : ( ( view_ext @ Z ) > cars ) ).

thf(sy_c_Views_Oview_Ovchop,type,
    vchop: ( view_ext @ product_unit ) > ( view_ext @ product_unit ) > ( view_ext @ product_unit ) > $o ).

thf(sy_v_c____,type,
    c: cars ).

thf(sy_v_d____,type,
    d: cars ).

thf(sy_v_e____,type,
    e: cars ).

thf(sy_v_thesis____,type,
    thesis: $o ).

thf(sy_v_ts_H_H____,type,
    ts: traffic ).

thf(sy_v_ts_H____,type,
    ts2: traffic ).

thf(sy_v_ts_Ha____,type,
    ts_a: traffic ).

thf(sy_v_ts____,type,
    ts3: traffic ).

thf(sy_v_v____,type,
    v: view_ext @ product_unit ).

% Relevant facts (253)
thf(fact_0_neg,axiom,
    c != e ).

% neg
thf(fact_1_local_Ohmlsl_Osensors__ge,axiom,
    ! [E: cars,Ts: traffic,C: cars] : ( ord_less @ real @ ( zero_zero @ real ) @ ( regular_regular @ E @ Ts @ C ) ) ).

% local.hmlsl.sensors_ge
thf(fact_2_local_Ohmlsl_Olength__geq__zero,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( real_length @ ( ext @ product_unit @ V ) )
        = ( zero_zero @ real ) )
      | ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) ) ) ).

% local.hmlsl.length_geq_zero
thf(fact_3_hmlsl_Olen__empty__subview,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars,V3: view_ext @ product_unit] :
      ( ( ( ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) )
          = ( zero_zero @ real ) )
        & ( ord_less_eq @ ( view_ext @ product_unit ) @ V3 @ V2 ) )
     => ( ( real_length @ ( len @ regular_regular @ V3 @ Ts @ C ) )
        = ( zero_zero @ real ) ) ) ).

% hmlsl.len_empty_subview
thf(fact_4__092_060open_062_092_060exists_062v_H_092_060le_062move_Ats_Ats_H_H_Av_O_A_I0_A_060_A_092_060parallel_062ext_Av_H_092_060parallel_062_A_092_060and_062_Alen_Av_H_Ats_H_H_Ac_A_061_Aext_Av_H_A_092_060and_062_Arestrict_Av_H_A_Ires_Ats_H_H_J_Ac_A_061_Alan_Av_H_A_092_060and_062_A_124lan_Av_H_124_A_061_A1_J_A_092_060and_062_A0_A_060_A_092_060parallel_062ext_Av_H_092_060parallel_062_A_092_060and_062_Alen_Av_H_Ats_H_H_Ae_A_061_Aext_Av_H_A_092_060and_062_Arestrict_Av_H_A_Ires_Ats_H_H_J_Ae_A_061_Alan_Av_H_A_092_060and_062_A_124lan_Av_H_124_A_061_A1_092_060close_062,axiom,
    ? [V4: view_ext @ product_unit] :
      ( ( ord_less_eq @ ( view_ext @ product_unit ) @ V4 @ ( move @ ts3 @ ts @ v ) )
      & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V4 ) ) )
      & ( ( len @ regular_regular @ V4 @ ts @ c )
        = ( ext @ product_unit @ V4 ) )
      & ( ( restrict @ V4 @ ( res @ ts ) @ c )
        = ( lan @ product_unit @ V4 ) )
      & ( ( nat_card @ ( lan @ product_unit @ V4 ) )
        = ( one_one @ nat ) )
      & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V4 ) ) )
      & ( ( len @ regular_regular @ V4 @ ts @ e )
        = ( ext @ product_unit @ V4 ) )
      & ( ( restrict @ V4 @ ( res @ ts ) @ e )
        = ( lan @ product_unit @ V4 ) )
      & ( ( nat_card @ ( lan @ product_unit @ V4 ) )
        = ( one_one @ nat ) ) ) ).

% \<open>\<exists>v'\<le>move ts ts'' v. (0 < \<parallel>ext v'\<parallel> \<and> len v' ts'' c = ext v' \<and> restrict v' (res ts'') c = lan v' \<and> |lan v'| = 1) \<and> 0 < \<parallel>ext v'\<parallel> \<and> len v' ts'' e = ext v' \<and> restrict v' (res ts'') e = lan v' \<and> |lan v'| = 1\<close>
thf(fact_5_local_Ohmlsl_Ores__ge__zero,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
     => ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) ) ) ).

% local.hmlsl.res_ge_zero
thf(fact_6_local_Ohmlsl_Owidth__res,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
     => ( ( nat_card @ ( lan @ product_unit @ V ) )
        = ( one_one @ nat ) ) ) ).

% local.hmlsl.width_res
thf(fact_7_abs,axiom,
    abstract @ ts3 @ ts2 ).

% abs
thf(fact_8__092_060open_062move_Ats_Ats_H_Av_A_061_Amove_Ats_H_Ats_H_H_A_Imove_Ats_Ats_H_Av_J_092_060close_062,axiom,
    ( ( move @ ts3 @ ts_a @ v )
    = ( move @ ts_a @ ts @ ( move @ ts3 @ ts_a @ v ) ) ) ).

% \<open>move ts ts' v = move ts' ts'' (move ts ts' v)\<close>
thf(fact_9_move__stab,axiom,
    ( ( move @ ts3 @ ts_a @ v )
    = ( move @ ts3 @ ts @ v ) ) ).

% move_stab
thf(fact_10_local_Ohmlsl_Ores__compose,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext @ product_unit @ U ) )
          & ( ( restrict @ U @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ U ) )
          & ( ( nat_card @ ( lan @ product_unit @ U ) )
            = ( one_one @ nat ) ) )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.res_compose
thf(fact_11_local_Ohmlsl_Ores__decompose,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va2 ) ) )
          & ( ( len @ regular_regular @ Va2 @ Ts2 @ C )
            = ( ext @ product_unit @ Va2 ) )
          & ( ( restrict @ Va2 @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va2 ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va2 ) )
            = ( one_one @ nat ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U2 ) ) )
          & ( ( len @ regular_regular @ U2 @ Ts2 @ C )
            = ( ext @ product_unit @ U2 ) )
          & ( ( restrict @ U2 @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ U2 ) )
          & ( ( nat_card @ ( lan @ product_unit @ U2 ) )
            = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.res_decompose
thf(fact_12_local_Ohmlsl_Ores__dense,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ W ) ) )
            & ( ( len @ regular_regular @ W @ Ts2 @ C )
              = ( ext @ product_unit @ W ) )
            & ( ( restrict @ W @ ( res @ Ts2 ) @ C )
              = ( lan @ product_unit @ W ) )
            & ( ( nat_card @ ( lan @ product_unit @ W ) )
              = ( one_one @ nat ) )
            & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U3 ) ) )
            & ( ( len @ regular_regular @ U3 @ Ts2 @ C )
              = ( ext @ product_unit @ U3 ) )
            & ( ( restrict @ U3 @ ( res @ Ts2 ) @ C )
              = ( lan @ product_unit @ U3 ) )
            & ( ( nat_card @ ( lan @ product_unit @ U3 ) )
              = ( one_one @ nat ) ) ) ) ) ).

% local.hmlsl.res_dense
thf(fact_13_local_Ohmlsl_Ocar__one__lane__non__empty,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ? [X: cars] :
          ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts2 @ X )
              = ( ext @ product_unit @ V ) )
            & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
              = ( lan @ product_unit @ V ) )
            & ( ( nat_card @ ( lan @ product_unit @ V ) )
              = ( one_one @ nat ) ) )
          | ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts2 @ X )
              = ( ext @ product_unit @ V ) )
            & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
              = ( lan @ product_unit @ V ) )
            & ( ( nat_card @ ( lan @ product_unit @ V ) )
              = ( one_one @ nat ) ) ) )
     => ( ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) ) ) ) ).

% local.hmlsl.car_one_lane_non_empty
thf(fact_14_local_Ohmlsl_Oempty__no__car,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( real_length @ ( ext @ product_unit @ V ) )
        = ( zero_zero @ real ) )
     => ~ ? [X: cars] :
            ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext @ product_unit @ V ) )
              & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
                = ( lan @ product_unit @ V ) )
              & ( ( nat_card @ ( lan @ product_unit @ V ) )
                = ( one_one @ nat ) ) )
            | ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext @ product_unit @ V ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
                = ( lan @ product_unit @ V ) )
              & ( ( nat_card @ ( lan @ product_unit @ V ) )
                = ( one_one @ nat ) ) ) ) ) ).

% local.hmlsl.empty_no_car
thf(fact_15_local_Ohmlsl_Otwo__lanes__no__car,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( nat_card @ ( lan @ product_unit @ V ) )
       != ( one_one @ nat ) )
     => ~ ? [X: cars] :
            ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext @ product_unit @ V ) )
              & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
                = ( lan @ product_unit @ V ) )
              & ( ( nat_card @ ( lan @ product_unit @ V ) )
                = ( one_one @ nat ) ) )
            | ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext @ product_unit @ V ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
                = ( lan @ product_unit @ V ) )
              & ( ( nat_card @ ( lan @ product_unit @ V ) )
                = ( one_one @ nat ) ) ) ) ) ).

% local.hmlsl.two_lanes_no_car
thf(fact_16_local_Ohmlsl_Ores__at__most__two,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ~ ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ? [Vb: view_ext @ product_unit,Ua: view_ext @ product_unit] :
              ( ( vchop @ U @ Vb @ Ua )
              & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Vb ) ) )
              & ( ( len @ regular_regular @ Vb @ Ts2 @ C )
                = ( ext @ product_unit @ Vb ) )
              & ( ( restrict @ Vb @ ( res @ Ts2 ) @ C )
                = ( lan @ product_unit @ Vb ) )
              & ( ( nat_card @ ( lan @ product_unit @ Vb ) )
                = ( one_one @ nat ) )
              & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Ua ) ) )
              & ( ( len @ regular_regular @ Ua @ Ts2 @ C )
                = ( ext @ product_unit @ Ua ) )
              & ( ( restrict @ Ua @ ( res @ Ts2 ) @ C )
                = ( lan @ product_unit @ Ua ) )
              & ( ( nat_card @ ( lan @ product_unit @ Ua ) )
                = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.res_at_most_two
thf(fact_17_local_Ohmlsl_Otwo__res__not__res,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext @ product_unit @ U ) )
          & ( ( restrict @ U @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ U ) )
          & ( ( nat_card @ ( lan @ product_unit @ U ) )
            = ( one_one @ nat ) ) )
     => ~ ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext @ product_unit @ V ) )
          & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ V ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.two_res_not_res
thf(fact_18_local_Ohmlsl_Oclm__ge__zero,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
     => ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) ) ) ).

% local.hmlsl.clm_ge_zero
thf(fact_19_local_Ohmlsl_Ohchop__weaken2,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( Phi @ Ts2 @ U2 ) ) ) ).

% local.hmlsl.hchop_weaken2
thf(fact_20_local_Ohmlsl_Ohchop__weaken1,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_ext @ product_unit] :
          ( ? [X_1: view_ext @ product_unit] : ( hchop @ V @ Va2 @ X_1 )
          & ( Phi @ Ts2 @ Va2 ) ) ) ).

% local.hmlsl.hchop_weaken1
thf(fact_21_local_Ohmlsl_Ohchop__weaken,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ? [Vb2: view_ext @ product_unit] :
              ( ? [X_1: view_ext @ product_unit] : ( hchop @ U2 @ Vb2 @ X_1 )
              & ( Phi @ Ts2 @ Vb2 ) ) ) ) ).

% local.hmlsl.hchop_weaken
thf(fact_22_local_Ohmlsl_Ohchop__neg2,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ~ ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
            ( ( hchop @ V @ Va2 @ U2 )
            & ( Phi @ Ts2 @ U2 ) )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ~ ( Phi @ Ts2 @ U2 ) ) ) ).

% local.hmlsl.hchop_neg2
thf(fact_23_local_Ohmlsl_Ohchop__neg1,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ~ ? [Va2: view_ext @ product_unit] :
            ( ? [X_1: view_ext @ product_unit] : ( hchop @ V @ Va2 @ X_1 )
            & ( Phi @ Ts2 @ Va2 ) )
     => ? [Va2: view_ext @ product_unit] :
          ( ? [X_1: view_ext @ product_unit] : ( hchop @ V @ Va2 @ X_1 )
          & ~ ( Phi @ Ts2 @ Va2 ) ) ) ).

% local.hmlsl.hchop_neg1
thf(fact_24_local_Ohmlsl_Ohchop__disj__distr2,axiom,
    ! [Psi: traffic > ( view_ext @ product_unit ) > $o,Chi: traffic > ( view_ext @ product_unit ) > $o,Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ( Psi @ Ts2 @ W )
              | ( Chi @ Ts2 @ W ) )
            & ( Phi @ Ts2 @ U3 ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Psi @ Ts2 @ W )
            & ( Phi @ Ts2 @ U3 ) )
        | ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Chi @ Ts2 @ W )
            & ( Phi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.hchop_disj_distr2
thf(fact_25_local_Ohmlsl_Ohchop__disj__distr1,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Psi: traffic > ( view_ext @ product_unit ) > $o,Chi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( ( Psi @ Ts2 @ U3 )
              | ( Chi @ Ts2 @ U3 ) ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( Psi @ Ts2 @ U3 ) )
        | ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( Chi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.hchop_disj_distr1
thf(fact_26_local_Ohmlsl_Ohchop__assoc,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Psi: traffic > ( view_ext @ product_unit ) > $o,Chi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ? [X2: view_ext @ product_unit,Y: view_ext @ product_unit] :
                ( ( hchop @ U3 @ X2 @ Y )
                & ( Psi @ Ts2 @ X2 )
                & ( Chi @ Ts2 @ Y ) ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ? [X2: view_ext @ product_unit,Y: view_ext @ product_unit] :
                ( ( hchop @ W @ X2 @ Y )
                & ( Phi @ Ts2 @ X2 )
                & ( Psi @ Ts2 @ Y ) )
            & ( Chi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.hchop_assoc
thf(fact_27_local_Ohmlsl_Ovchop__disj__distr2,axiom,
    ! [Psi: traffic > ( view_ext @ product_unit ) > $o,Chi: traffic > ( view_ext @ product_unit ) > $o,Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( ( Psi @ Ts2 @ W )
              | ( Chi @ Ts2 @ W ) )
            & ( Phi @ Ts2 @ U3 ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Psi @ Ts2 @ W )
            & ( Phi @ Ts2 @ U3 ) )
        | ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Chi @ Ts2 @ W )
            & ( Phi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.vchop_disj_distr2
thf(fact_28_local_Ohmlsl_Ovchop__disj__distr1,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Psi: traffic > ( view_ext @ product_unit ) > $o,Chi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( ( Psi @ Ts2 @ U3 )
              | ( Chi @ Ts2 @ U3 ) ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( Psi @ Ts2 @ U3 ) )
        | ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ( Chi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.vchop_disj_distr1
thf(fact_29_local_Ohmlsl_Ov__chop__weaken2,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( vchop @ V @ Va2 @ U2 )
          & ( Phi @ Ts2 @ U2 ) ) ) ).

% local.hmlsl.v_chop_weaken2
thf(fact_30_local_Ohmlsl_Ov__chop__weaken1,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( Phi @ Ts2 @ V )
     => ? [Va2: view_ext @ product_unit] :
          ( ? [X_1: view_ext @ product_unit] : ( vchop @ V @ Va2 @ X_1 )
          & ( Phi @ Ts2 @ Va2 ) ) ) ).

% local.hmlsl.v_chop_weaken1
thf(fact_31_local_Ohmlsl_Ov__chop__assoc,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Psi: traffic > ( view_ext @ product_unit ) > $o,Chi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( Phi @ Ts2 @ W )
            & ? [X2: view_ext @ product_unit,Y: view_ext @ product_unit] :
                ( ( vchop @ U3 @ X2 @ Y )
                & ( Psi @ Ts2 @ X2 )
                & ( Chi @ Ts2 @ Y ) ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ? [X2: view_ext @ product_unit,Y: view_ext @ product_unit] :
                ( ( vchop @ W @ X2 @ Y )
                & ( Phi @ Ts2 @ X2 )
                & ( Psi @ Ts2 @ Y ) )
            & ( Chi @ Ts2 @ U3 ) ) ) ) ).

% local.hmlsl.v_chop_assoc
thf(fact_32_local_Ohmlsl_Oglobally__refl,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ! [Ts3: traffic] :
          ( ( abstract @ Ts2 @ Ts3 )
         => ( Phi @ Ts3 @ ( move @ Ts2 @ Ts3 @ V ) ) )
     => ( Phi @ Ts2 @ V ) ) ).

% local.hmlsl.globally_refl
thf(fact_33_local_Ohmlsl_Oglobally__all__iff_H,axiom,
    ! [A: $tType,B: $tType,Ts: traffic,Phi: traffic > ( view_ext @ product_unit ) > $o,V2: view_ext @ product_unit] :
      ( ( ! [Ts4: traffic] :
            ( ( abstract @ Ts @ Ts4 )
           => ! [X2: A] : ( Phi @ Ts4 @ ( move @ Ts @ Ts4 @ V2 ) ) ) )
      = ( ! [X2: B,Ts4: traffic] :
            ( ( abstract @ Ts @ Ts4 )
           => ( Phi @ Ts4 @ ( move @ Ts @ Ts4 @ V2 ) ) ) ) ) ).

% local.hmlsl.globally_all_iff'
thf(fact_34_local_Ohmlsl_Oglobally__all__iff,axiom,
    ! [A: $tType,B: $tType,Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ! [Ts4: traffic] :
            ( ( abstract @ Ts2 @ Ts4 )
           => ! [X2: A] : ( Phi @ Ts4 @ ( move @ Ts2 @ Ts4 @ V ) ) ) )
      = ( ! [X2: B,Ts4: traffic] :
            ( ( abstract @ Ts2 @ Ts4 )
           => ( Phi @ Ts4 @ ( move @ Ts2 @ Ts4 @ V ) ) ) ) ) ).

% local.hmlsl.globally_all_iff
thf(fact_35_local_Ohmlsl_Oglobally__4,axiom,
    ! [Phi: traffic > ( view_ext @ product_unit ) > $o,Ts2: traffic,V: view_ext @ product_unit] :
      ( ! [Ts3: traffic] :
          ( ( abstract @ Ts2 @ Ts3 )
         => ( Phi @ Ts3 @ ( move @ Ts2 @ Ts3 @ V ) ) )
     => ! [Ts5: traffic] :
          ( ( abstract @ Ts2 @ Ts5 )
         => ! [Ts_a: traffic] :
              ( ( abstract @ Ts5 @ Ts_a )
             => ( Phi @ Ts_a @ ( move @ Ts5 @ Ts_a @ ( move @ Ts2 @ Ts5 @ V ) ) ) ) ) ) ).

% local.hmlsl.globally_4
thf(fact_36_wd__clm_Ohyps_I1_J,axiom,
    abstract @ ts3 @ ts_a ).

% wd_clm.hyps(1)
thf(fact_37_local_Ohmlsl_Owidth__hchop__stable,axiom,
    ! [X3: nat,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( nat_card @ ( lan @ product_unit @ V ) )
        = X3 )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ( nat_card @ ( lan @ product_unit @ W ) )
              = X3 )
            & ( ( nat_card @ ( lan @ product_unit @ U3 ) )
              = X3 ) ) ) ) ).

% local.hmlsl.width_hchop_stable
thf(fact_38_local_Ohmlsl_Olength__vchop__stable,axiom,
    ! [X3: real,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( real_length @ ( ext @ product_unit @ V ) )
        = X3 )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( vchop @ V @ W @ U3 )
            & ( ( real_length @ ( ext @ product_unit @ W ) )
              = X3 )
            & ( ( real_length @ ( ext @ product_unit @ U3 ) )
              = X3 ) ) ) ) ).

% local.hmlsl.length_vchop_stable
thf(fact_39_hmlsl_Olen__stable__up,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,Ts: traffic,C: cars] :
      ( ( vchop @ V2 @ V1 @ V22 )
     => ( ( len @ regular_regular @ V2 @ Ts @ C )
        = ( len @ regular_regular @ V22 @ Ts @ C ) ) ) ).

% hmlsl.len_stable_up
thf(fact_40_hmlsl_Olen__stable__down,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,Ts: traffic,C: cars] :
      ( ( vchop @ V2 @ V1 @ V22 )
     => ( ( len @ regular_regular @ V2 @ Ts @ C )
        = ( len @ regular_regular @ V1 @ Ts @ C ) ) ) ).

% hmlsl.len_stable_down
thf(fact_41_hmlsl_Olen__stable,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,Ts: traffic,C: cars] :
      ( ( vchop @ V2 @ V1 @ V22 )
     => ( ( len @ regular_regular @ V1 @ Ts @ C )
        = ( len @ regular_regular @ V22 @ Ts @ C ) ) ) ).

% hmlsl.len_stable
thf(fact_42_hmlsl_Olen__view__hchop__right,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars,V1: view_ext @ product_unit,V22: view_ext @ product_unit] :
      ( ( ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( hchop @ V2 @ V1 @ V22 ) )
     => ( ( len @ regular_regular @ V22 @ Ts @ C )
        = ( ext @ product_unit @ V22 ) ) ) ).

% hmlsl.len_view_hchop_right
thf(fact_43_hmlsl_Olen__view__hchop__left,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars,V1: view_ext @ product_unit,V22: view_ext @ product_unit] :
      ( ( ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( hchop @ V2 @ V1 @ V22 ) )
     => ( ( len @ regular_regular @ V1 @ Ts @ C )
        = ( ext @ product_unit @ V1 ) ) ) ).

% hmlsl.len_view_hchop_left
thf(fact_44_hmlsl_Olen__compose__hchop,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,Ts: traffic,C: cars] :
      ( ( ( hchop @ V2 @ V1 @ V22 )
        & ( ( len @ regular_regular @ V1 @ Ts @ C )
          = ( ext @ product_unit @ V1 ) )
        & ( ( len @ regular_regular @ V22 @ Ts @ C )
          = ( ext @ product_unit @ V22 ) ) )
     => ( ( len @ regular_regular @ V2 @ Ts @ C )
        = ( ext @ product_unit @ V2 ) ) ) ).

% hmlsl.len_compose_hchop
thf(fact_45_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X4: A] :
          ( ( F @ X4 )
          = ( G @ X4 ) )
     => ( F = G ) ) ).

% ext
thf(fact_46_wd__clm_Ohyps_I2_J,axiom,
    ? [C2: cars] : ( withdraw_claim @ ts_a @ C2 @ ts ) ).

% wd_clm.hyps(2)
thf(fact_47_local_Ohmlsl_Olength__split,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va2 ) ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U2 ) ) ) ) ) ).

% local.hmlsl.length_split
thf(fact_48_local_Ohmlsl_Olength__meld,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U ) ) ) )
     => ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) ) ) ).

% local.hmlsl.length_meld
thf(fact_49_local_Ohmlsl_Olength__dense,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ W ) ) )
            & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U3 ) ) ) ) ) ) ).

% local.hmlsl.length_dense
thf(fact_50_hmlsl_Olen__empty__on__subview2,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars,V1: view_ext @ product_unit,V22: view_ext @ product_unit] :
      ( ( ( ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) )
          = ( zero_zero @ real ) )
        & ( hchop @ V2 @ V1 @ V22 ) )
     => ( ( real_length @ ( len @ regular_regular @ V22 @ Ts @ C ) )
        = ( zero_zero @ real ) ) ) ).

% hmlsl.len_empty_on_subview2
thf(fact_51_hmlsl_Olen__empty__on__subview1,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars,V1: view_ext @ product_unit,V22: view_ext @ product_unit] :
      ( ( ( ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) )
          = ( zero_zero @ real ) )
        & ( hchop @ V2 @ V1 @ V22 ) )
     => ( ( real_length @ ( len @ regular_regular @ V1 @ Ts @ C ) )
        = ( zero_zero @ real ) ) ) ).

% hmlsl.len_empty_on_subview1
thf(fact_52_hmlsl_Olen__fills__subview,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) ) )
     => ? [V12: view_ext @ product_unit,V23: view_ext @ product_unit,V32: view_ext @ product_unit,V4: view_ext @ product_unit] :
          ( ( hchop @ V2 @ V12 @ V23 )
          & ( hchop @ V23 @ V4 @ V32 )
          & ( ( len @ regular_regular @ V4 @ Ts @ C )
            = ( ext @ product_unit @ V4 ) )
          & ( ( real_length @ ( len @ regular_regular @ V4 @ Ts @ C ) )
            = ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) ) ) ) ) ).

% hmlsl.len_fills_subview
thf(fact_53_d__def,axiom,
    withdraw_claim @ ts_a @ d @ ts ).

% d_def
thf(fact_54_local_Ohmlsl_Owidth__clm,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
     => ( ( nat_card @ ( lan @ product_unit @ V ) )
        = ( one_one @ nat ) ) ) ).

% local.hmlsl.width_clm
thf(fact_55_local_Ohmlsl_Oclm__dense,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ W ) ) )
            & ( ( len @ regular_regular @ W @ Ts2 @ C )
              = ( ext @ product_unit @ W ) )
            & ( ( restrict @ W @ ( clm @ Ts2 ) @ C )
              = ( lan @ product_unit @ W ) )
            & ( ( nat_card @ ( lan @ product_unit @ W ) )
              = ( one_one @ nat ) )
            & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U3 ) ) )
            & ( ( len @ regular_regular @ U3 @ Ts2 @ C )
              = ( ext @ product_unit @ U3 ) )
            & ( ( restrict @ U3 @ ( clm @ Ts2 ) @ C )
              = ( lan @ product_unit @ U3 ) )
            & ( ( nat_card @ ( lan @ product_unit @ U3 ) )
              = ( one_one @ nat ) ) ) ) ) ).

% local.hmlsl.clm_dense
thf(fact_56_local_Ohmlsl_Oclm__decompose,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va2 ) ) )
          & ( ( len @ regular_regular @ Va2 @ Ts2 @ C )
            = ( ext @ product_unit @ Va2 ) )
          & ( ( restrict @ Va2 @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va2 ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va2 ) )
            = ( one_one @ nat ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U2 ) ) )
          & ( ( len @ regular_regular @ U2 @ Ts2 @ C )
            = ( ext @ product_unit @ U2 ) )
          & ( ( restrict @ U2 @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ U2 ) )
          & ( ( nat_card @ ( lan @ product_unit @ U2 ) )
            = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.clm_decompose
thf(fact_57_local_Ohmlsl_Oclm__compose,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext @ product_unit @ U ) )
          & ( ( restrict @ U @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ U ) )
          & ( ( nat_card @ ( lan @ product_unit @ U ) )
            = ( one_one @ nat ) ) )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ C )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.clm_compose
thf(fact_58_local_Ohmlsl_Oclm__sing__not__interrupted,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ~ ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ? [Vb: view_ext @ product_unit,Ua: view_ext @ product_unit] :
              ( ( vchop @ U @ Vb @ Ua )
              & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Ua ) ) )
              & ( ( len @ regular_regular @ Ua @ Ts2 @ C )
                = ( ext @ product_unit @ Ua ) )
              & ( ( restrict @ Ua @ ( clm @ Ts2 ) @ C )
                = ( lan @ product_unit @ Ua ) )
              & ( ( nat_card @ ( lan @ product_unit @ Ua ) )
                = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.clm_sing_not_interrupted
thf(fact_59_local_Ohmlsl_Oclm__sing,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ~ ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext @ product_unit @ U ) )
          & ( ( restrict @ U @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ U ) )
          & ( ( nat_card @ ( lan @ product_unit @ U ) )
            = ( one_one @ nat ) ) ) ).

% local.hmlsl.clm_sing
thf(fact_60_local_Ohmlsl_Ono__clm__before__res2,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ~ ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ? [Vb: view_ext @ product_unit,Ua: view_ext @ product_unit] :
              ( ( hchop @ U @ Vb @ Ua )
              & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Ua ) ) )
              & ( ( len @ regular_regular @ Ua @ Ts2 @ C )
                = ( ext @ product_unit @ Ua ) )
              & ( ( restrict @ Ua @ ( res @ Ts2 ) @ C )
                = ( lan @ product_unit @ Ua ) )
              & ( ( nat_card @ ( lan @ product_unit @ Ua ) )
                = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.no_clm_before_res2
thf(fact_61_local_Ohmlsl_Ono__clm__before__res,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ~ ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext @ product_unit @ U ) )
          & ( ( restrict @ U @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ U ) )
          & ( ( nat_card @ ( lan @ product_unit @ U ) )
            = ( one_one @ nat ) ) ) ).

% local.hmlsl.no_clm_before_res
thf(fact_62_local_Ohmlsl_Otwo__res__no__car,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( len @ regular_regular @ Va @ Ts2 @ C )
            = ( ext @ product_unit @ Va ) )
          & ( ( restrict @ Va @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ Va ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U ) ) )
          & ( ( len @ regular_regular @ U @ Ts2 @ C )
            = ( ext @ product_unit @ U ) )
          & ( ( restrict @ U @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ U ) )
          & ( ( nat_card @ ( lan @ product_unit @ U ) )
            = ( one_one @ nat ) ) )
     => ~ ? [X: cars] :
            ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext @ product_unit @ V ) )
              & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
                = ( lan @ product_unit @ V ) )
              & ( ( nat_card @ ( lan @ product_unit @ V ) )
                = ( one_one @ nat ) ) )
            | ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts2 @ X )
                = ( ext @ product_unit @ V ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
                = ( lan @ product_unit @ V ) )
              & ( ( nat_card @ ( lan @ product_unit @ V ) )
                = ( one_one @ nat ) ) ) ) ) ).

% local.hmlsl.two_res_no_car
thf(fact_63__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062d_O_Ats_H_A_092_060_094bold_062_092_060midarrow_062wdc_I_Ad_A_J_A_092_060_094bold_062_092_060rightarrow_062_Ats_H_H_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [D: cars] :
        ~ ( withdraw_claim @ ts_a @ D @ ts ) ).

% \<open>\<And>thesis. (\<And>d. ts' \<^bold>\<midarrow>wdc( d ) \<^bold>\<rightarrow> ts'' \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_64_local_Ohmlsl_Ofree__dense,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) )
        & ! [C3: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C3 ) )
              = ( zero_zero @ real ) )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C3 )
                = ( bot_bot @ nat_int ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C3 )
                = ( bot_bot @ nat_int ) ) ) ) )
      = ( ? [W: view_ext @ product_unit,U3: view_ext @ product_unit] :
            ( ( hchop @ V @ W @ U3 )
            & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ W ) ) )
            & ( ( nat_card @ ( lan @ product_unit @ W ) )
              = ( one_one @ nat ) )
            & ! [C3: cars] :
                ( ( ( real_length @ ( len @ regular_regular @ W @ Ts2 @ C3 ) )
                  = ( zero_zero @ real ) )
                | ( ( ( restrict @ W @ ( clm @ Ts2 ) @ C3 )
                    = ( bot_bot @ nat_int ) )
                  & ( ( restrict @ W @ ( res @ Ts2 ) @ C3 )
                    = ( bot_bot @ nat_int ) ) ) )
            & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U3 ) ) )
            & ( ( nat_card @ ( lan @ product_unit @ U3 ) )
              = ( one_one @ nat ) )
            & ! [C3: cars] :
                ( ( ( real_length @ ( len @ regular_regular @ U3 @ Ts2 @ C3 ) )
                  = ( zero_zero @ real ) )
                | ( ( ( restrict @ U3 @ ( clm @ Ts2 ) @ C3 )
                    = ( bot_bot @ nat_int ) )
                  & ( ( restrict @ U3 @ ( res @ Ts2 ) @ C3 )
                    = ( bot_bot @ nat_int ) ) ) ) ) ) ) ).

% local.hmlsl.free_dense
thf(fact_65_local_Ohmlsl_Ofree__decompose,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = ( zero_zero @ real ) )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) ) ) ) )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( hchop @ V @ Va2 @ U2 )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va2 ) ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va2 ) )
            = ( one_one @ nat ) )
          & ! [C4: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ Va2 @ Ts2 @ C4 ) )
                = ( zero_zero @ real ) )
              | ( ( ( restrict @ Va2 @ ( clm @ Ts2 ) @ C4 )
                  = ( bot_bot @ nat_int ) )
                & ( ( restrict @ Va2 @ ( res @ Ts2 ) @ C4 )
                  = ( bot_bot @ nat_int ) ) ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U2 ) ) )
          & ( ( nat_card @ ( lan @ product_unit @ U2 ) )
            = ( one_one @ nat ) )
          & ! [C4: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ U2 @ Ts2 @ C4 ) )
                = ( zero_zero @ real ) )
              | ( ( ( restrict @ U2 @ ( clm @ Ts2 ) @ C4 )
                  = ( bot_bot @ nat_int ) )
                & ( ( restrict @ U2 @ ( res @ Ts2 ) @ C4 )
                  = ( bot_bot @ nat_int ) ) ) ) ) ) ).

% local.hmlsl.free_decompose
thf(fact_66_local_Ohmlsl_Ofree__compose,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( hchop @ V @ Va @ U )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ Va ) ) )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( one_one @ nat ) )
          & ! [C2: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ Va @ Ts2 @ C2 ) )
                = ( zero_zero @ real ) )
              | ( ( ( restrict @ Va @ ( clm @ Ts2 ) @ C2 )
                  = ( bot_bot @ nat_int ) )
                & ( ( restrict @ Va @ ( res @ Ts2 ) @ C2 )
                  = ( bot_bot @ nat_int ) ) ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U ) ) )
          & ( ( nat_card @ ( lan @ product_unit @ U ) )
            = ( one_one @ nat ) )
          & ! [C2: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ U @ Ts2 @ C2 ) )
                = ( zero_zero @ real ) )
              | ( ( ( restrict @ U @ ( clm @ Ts2 ) @ C2 )
                  = ( bot_bot @ nat_int ) )
                & ( ( restrict @ U @ ( res @ Ts2 ) @ C2 )
                  = ( bot_bot @ nat_int ) ) ) ) )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) )
        & ! [C4: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C4 ) )
              = ( zero_zero @ real ) )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C4 )
                = ( bot_bot @ nat_int ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C4 )
                = ( bot_bot @ nat_int ) ) ) ) ) ) ).

% local.hmlsl.free_compose
thf(fact_67_local_Ohmlsl_Owidth__free,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = ( zero_zero @ real ) )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) ) ) ) )
     => ( ( nat_card @ ( lan @ product_unit @ V ) )
        = ( one_one @ nat ) ) ) ).

% local.hmlsl.width_free
thf(fact_68_local_Ohmlsl_Ores__not__free,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
    ? [X4: cars] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ X4 )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( res @ Ts2 ) @ X4 )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
     => ~ ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) )
          & ! [C2: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
                = ( zero_zero @ real ) )
              | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                  = ( bot_bot @ nat_int ) )
                & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                  = ( bot_bot @ nat_int ) ) ) ) ) ) ).

% local.hmlsl.res_not_free
thf(fact_69_local_Ohmlsl_Ofree__no__res,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = ( zero_zero @ real ) )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) ) ) ) )
     => ~ ? [X: cars] :
            ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts2 @ X )
              = ( ext @ product_unit @ V ) )
            & ( ( restrict @ V @ ( res @ Ts2 ) @ X )
              = ( lan @ product_unit @ V ) )
            & ( ( nat_card @ ( lan @ product_unit @ V ) )
              = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.free_no_res
thf(fact_70_local_Ohmlsl_Ofree__no__clm,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = ( zero_zero @ real ) )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) ) ) ) )
     => ~ ? [X: cars] :
            ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts2 @ X )
              = ( ext @ product_unit @ V ) )
            & ( ( restrict @ V @ ( clm @ Ts2 ) @ X )
              = ( lan @ product_unit @ V ) )
            & ( ( nat_card @ ( lan @ product_unit @ V ) )
              = ( one_one @ nat ) ) ) ) ).

% local.hmlsl.free_no_clm
thf(fact_71_local_Ohmlsl_Ofree__ge__zero,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) )
        & ! [C2: cars] :
            ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
              = ( zero_zero @ real ) )
            | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) )
              & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                = ( bot_bot @ nat_int ) ) ) ) )
     => ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) ) ) ).

% local.hmlsl.free_ge_zero
thf(fact_72_local_Ohmlsl_Oclm__not__free,axiom,
    ! [Ts2: traffic,V: view_ext @ product_unit] :
    ? [X4: cars] :
      ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
        & ( ( len @ regular_regular @ V @ Ts2 @ X4 )
          = ( ext @ product_unit @ V ) )
        & ( ( restrict @ V @ ( clm @ Ts2 ) @ X4 )
          = ( lan @ product_unit @ V ) )
        & ( ( nat_card @ ( lan @ product_unit @ V ) )
          = ( one_one @ nat ) ) )
     => ~ ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) )
          & ! [C2: cars] :
              ( ( ( real_length @ ( len @ regular_regular @ V @ Ts2 @ C2 ) )
                = ( zero_zero @ real ) )
              | ( ( ( restrict @ V @ ( clm @ Ts2 ) @ C2 )
                  = ( bot_bot @ nat_int ) )
                & ( ( restrict @ V @ ( res @ Ts2 ) @ C2 )
                  = ( bot_bot @ nat_int ) ) ) ) ) ) ).

% local.hmlsl.clm_not_free
thf(fact_73_hmlsl__regular_Obackwards__wdc__res__stab,axiom,
    ! [Ts: traffic,D2: cars,Ts6: traffic,V2: view_ext @ product_unit,C: cars] :
      ( ( ( withdraw_claim @ Ts @ D2 @ Ts6 )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts6 @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts6 ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) ) ) ).

% hmlsl_regular.backwards_wdc_res_stab
thf(fact_74_view_Ohorizontal__chop__non__empty,axiom,
    ! [V2: view_ext @ product_unit] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
     => ? [U2: view_ext @ product_unit,W2: view_ext @ product_unit] :
          ( ( hchop @ V2 @ U2 @ W2 )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ U2 ) ) )
          & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ W2 ) ) ) ) ) ).

% view.horizontal_chop_non_empty
thf(fact_75_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_76_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_77_hmlsl__regular_Obackwards__c__res__stab,axiom,
    ! [Ts: traffic,D2: cars,N: nat,Ts6: traffic,V2: view_ext @ product_unit,C: cars] :
      ( ( ( create_claim @ Ts @ D2 @ N @ Ts6 )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts6 @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts6 ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) ) ) ).

% hmlsl_regular.backwards_c_res_stab
thf(fact_78_hmlsl__regular_Obackwards__wdr__res__stab,axiom,
    ! [Ts: traffic,D2: cars,N: nat,Ts6: traffic,V2: view_ext @ product_unit,C: cars] :
      ( ( ( withdraw_reservation @ Ts @ D2 @ N @ Ts6 )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts6 @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts6 ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) ) ) ).

% hmlsl_regular.backwards_wdr_res_stab
thf(fact_79_hmlsl_Olen__sub__int,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars] : ( ord_less_eq @ real_int @ ( len @ regular_regular @ V2 @ Ts @ C ) @ ( ext @ product_unit @ V2 ) ) ).

% hmlsl.len_sub_int
thf(fact_80_view_Overtical__chop__width__mon,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,V33: view_ext @ product_unit,V42: view_ext @ product_unit,X3: nat] :
      ( ( ( vchop @ V2 @ V1 @ V22 )
        & ( vchop @ V22 @ V33 @ V42 )
        & ( ( nat_card @ ( lan @ product_unit @ V33 ) )
          = X3 ) )
     => ( ord_less_eq @ nat @ X3 @ ( nat_card @ ( lan @ product_unit @ V2 ) ) ) ) ).

% view.vertical_chop_width_mon
thf(fact_81_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X3: A] :
          ( ( ( zero_zero @ A )
            = X3 )
          = ( X3
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_82_view_Overtical__chop__singleton,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( ( vchop @ V2 @ U4 @ W3 )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) )
     => ( ( ( nat_card @ ( lan @ product_unit @ U4 ) )
          = ( zero_zero @ nat ) )
        | ( ( nat_card @ ( lan @ product_unit @ W3 ) )
          = ( zero_zero @ nat ) ) ) ) ).

% view.vertical_chop_singleton
thf(fact_83_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A )
     => ! [X3: A] :
          ( ( ( one_one @ A )
            = X3 )
          = ( X3
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_84_view_Ohorizontal__chop1,axiom,
    ! [V2: view_ext @ product_unit] :
    ? [U2: view_ext @ product_unit,X_1: view_ext @ product_unit] : ( hchop @ V2 @ U2 @ X_1 ) ).

% view.horizontal_chop1
thf(fact_85_view_Ohorizontal__chop__assoc1,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,V33: view_ext @ product_unit,V42: view_ext @ product_unit] :
      ( ( ( hchop @ V2 @ V1 @ V22 )
        & ( hchop @ V22 @ V33 @ V42 ) )
     => ? [V4: view_ext @ product_unit] :
          ( ( hchop @ V2 @ V4 @ V42 )
          & ( hchop @ V4 @ V1 @ V33 ) ) ) ).

% view.horizontal_chop_assoc1
thf(fact_86_view_Ohorizontal__chop__assoc2,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,V33: view_ext @ product_unit,V42: view_ext @ product_unit] :
      ( ( ( hchop @ V2 @ V1 @ V22 )
        & ( hchop @ V1 @ V33 @ V42 ) )
     => ? [V4: view_ext @ product_unit] :
          ( ( hchop @ V2 @ V33 @ V4 )
          & ( hchop @ V4 @ V42 @ V22 ) ) ) ).

% view.horizontal_chop_assoc2
thf(fact_87_view_Ohorizontal__chop__empty__left,axiom,
    ! [V: view_ext @ product_unit] :
    ? [U2: view_ext @ product_unit] : ( hchop @ V @ U2 @ V ) ).

% view.horizontal_chop_empty_left
thf(fact_88_view_Ohorizontal__chop__empty__right,axiom,
    ! [V: view_ext @ product_unit] :
    ? [X_1: view_ext @ product_unit] : ( hchop @ V @ V @ X_1 ) ).

% view.horizontal_chop_empty_right
thf(fact_89_view_Overtical__chop1,axiom,
    ! [V: view_ext @ product_unit] :
    ? [U2: view_ext @ product_unit,X_1: view_ext @ product_unit] : ( vchop @ V @ U2 @ X_1 ) ).

% view.vertical_chop1
thf(fact_90_view_Overtical__chop__assoc1,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,V33: view_ext @ product_unit,V42: view_ext @ product_unit] :
      ( ( ( vchop @ V2 @ V1 @ V22 )
        & ( vchop @ V22 @ V33 @ V42 ) )
     => ? [V4: view_ext @ product_unit] :
          ( ( vchop @ V2 @ V4 @ V42 )
          & ( vchop @ V4 @ V1 @ V33 ) ) ) ).

% view.vertical_chop_assoc1
thf(fact_91_view_Overtical__chop__assoc2,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,V33: view_ext @ product_unit,V42: view_ext @ product_unit] :
      ( ( ( vchop @ V2 @ V1 @ V22 )
        & ( vchop @ V1 @ V33 @ V42 ) )
     => ? [V4: view_ext @ product_unit] :
          ( ( vchop @ V2 @ V33 @ V4 )
          & ( vchop @ V4 @ V42 @ V22 ) ) ) ).

% view.vertical_chop_assoc2
thf(fact_92_view_Overtical__chop__empty__up,axiom,
    ! [V: view_ext @ product_unit] :
    ? [U2: view_ext @ product_unit] : ( vchop @ V @ U2 @ V ) ).

% view.vertical_chop_empty_up
thf(fact_93_view_Overtical__chop__empty__down,axiom,
    ! [V: view_ext @ product_unit] :
    ? [X_1: view_ext @ product_unit] : ( vchop @ V @ V @ X_1 ) ).

% view.vertical_chop_empty_down
thf(fact_94_zero__le,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X3: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ X3 ) ) ).

% zero_le
thf(fact_95_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_96_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_97_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_98_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_99_view_Ohorizontal__chop__leq2,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq @ ( view_ext @ product_unit ) @ W3 @ V2 ) ) ).

% view.horizontal_chop_leq2
thf(fact_100_view_Ohorizontal__chop__leq1,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq @ ( view_ext @ product_unit ) @ U4 @ V2 ) ) ).

% view.horizontal_chop_leq1
thf(fact_101_view_Overtical__chop__leq2,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq @ ( view_ext @ product_unit ) @ W3 @ V2 ) ) ).

% view.vertical_chop_leq2
thf(fact_102_view_Overtical__chop__leq1,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq @ ( view_ext @ product_unit ) @ U4 @ V2 ) ) ).

% view.vertical_chop_leq1
thf(fact_103_view_Ohorizontal__chop__width__stable,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( nat_card @ ( lan @ product_unit @ U4 ) ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( nat_card @ ( lan @ product_unit @ W3 ) ) ) ) ) ).

% view.horizontal_chop_width_stable
thf(fact_104_view_Overtical__chop__length__stable,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ( ( real_length @ ( ext @ product_unit @ V2 ) )
          = ( real_length @ ( ext @ product_unit @ U4 ) ) )
        & ( ( real_length @ ( ext @ product_unit @ V2 ) )
          = ( real_length @ ( ext @ product_unit @ W3 ) ) ) ) ) ).

% view.vertical_chop_length_stable
thf(fact_105_view_Osomewhere__leq,axiom,
    ( ( ord_less_eq @ ( view_ext @ product_unit ) )
    = ( ^ [V5: view_ext @ product_unit,V6: view_ext @ product_unit] :
        ? [V13: view_ext @ product_unit,V24: view_ext @ product_unit,V34: view_ext @ product_unit,Vl: view_ext @ product_unit,Vr: view_ext @ product_unit,Vu: view_ext @ product_unit,Vd: view_ext @ product_unit] :
          ( ( hchop @ V6 @ Vl @ V13 )
          & ( hchop @ V13 @ V24 @ Vr )
          & ( vchop @ V24 @ Vd @ V34 )
          & ( vchop @ V34 @ V5 @ Vu ) ) ) ) ).

% view.somewhere_leq
thf(fact_106_hmlsl_Oview__leq__len__leq,axiom,
    ! [V2: view_ext @ product_unit,V3: view_ext @ product_unit,Ts: traffic,C: cars] :
      ( ( ( ord_less_eq @ real_int @ ( ext @ product_unit @ V2 ) @ ( ext @ product_unit @ V3 ) )
        & ( ( own @ product_unit @ V2 )
          = ( own @ product_unit @ V3 ) )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( len @ regular_regular @ V2 @ Ts @ C ) ) ) )
     => ( ord_less_eq @ real_int @ ( len @ regular_regular @ V2 @ Ts @ C ) @ ( len @ regular_regular @ V3 @ Ts @ C ) ) ) ).

% hmlsl.view_leq_len_leq
thf(fact_107_restriction_Orestriction__card__somewhere__mon,axiom,
    ! [V2: view_ext @ product_unit,Vl2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,Vr2: view_ext @ product_unit,Vu2: view_ext @ product_unit,V33: view_ext @ product_unit,V3: view_ext @ product_unit,Vd2: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( ( hchop @ V2 @ Vl2 @ V1 )
        & ( hchop @ V1 @ V22 @ Vr2 )
        & ( vchop @ V22 @ Vu2 @ V33 )
        & ( vchop @ V33 @ V3 @ Vd2 )
        & ( ( nat_card @ ( restrict @ V3 @ F @ C ) )
          = ( one_one @ nat ) ) )
     => ( ord_less_eq @ nat @ ( one_one @ nat ) @ ( nat_card @ ( restrict @ V2 @ F @ C ) ) ) ) ).

% restriction.restriction_card_somewhere_mon
thf(fact_108_hmlsl__regular_Obackwards__res__act,axiom,
    ! [Ts: traffic,C: cars,Ts6: traffic,V2: view_ext @ product_unit] :
      ( ( ( create_reservation @ Ts @ C @ Ts6 )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts6 @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts6 ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) )
     => ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
          & ( ( len @ regular_regular @ V2 @ Ts @ C )
            = ( ext @ product_unit @ V2 ) )
          & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
            = ( lan @ product_unit @ V2 ) )
          & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
            = ( one_one @ nat ) ) )
        | ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
          & ( ( len @ regular_regular @ V2 @ Ts @ C )
            = ( ext @ product_unit @ V2 ) )
          & ( ( restrict @ V2 @ ( clm @ Ts ) @ C )
            = ( lan @ product_unit @ V2 ) )
          & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
            = ( one_one @ nat ) ) ) ) ) ).

% hmlsl_regular.backwards_res_act
thf(fact_109_hmlsl__regular_Oreservation2,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ! [Ts3: traffic] :
          ( ( create_reservation @ Ts2 @ C @ Ts3 )
         => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts3 @ C )
              = ( ext @ product_unit @ V ) )
            & ( ( restrict @ V @ ( res @ Ts3 ) @ C )
              = ( lan @ product_unit @ V ) )
            & ( ( nat_card @ ( lan @ product_unit @ V ) )
              = ( one_one @ nat ) ) ) )
     => ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext @ product_unit @ V ) )
          & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ V ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) ) )
        | ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext @ product_unit @ V ) )
          & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ V ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) ) ) ) ) ).

% hmlsl_regular.reservation2
thf(fact_110_hmlsl__regular_Oreservation1,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext @ product_unit @ V ) )
          & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ V ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) ) )
        | ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext @ product_unit @ V ) )
          & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ V ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) ) ) )
     => ! [Ts5: traffic] :
          ( ( create_reservation @ Ts2 @ C @ Ts5 )
         => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
            & ( ( len @ regular_regular @ V @ Ts5 @ C )
              = ( ext @ product_unit @ V ) )
            & ( ( restrict @ V @ ( res @ Ts5 ) @ C )
              = ( lan @ product_unit @ V ) )
            & ( ( nat_card @ ( lan @ product_unit @ V ) )
              = ( one_one @ nat ) ) ) ) ) ).

% hmlsl_regular.reservation1
thf(fact_111_hmlsl__regular_Oreservation,axiom,
    ! [C: cars,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ! [Ts4: traffic] :
            ( ( create_reservation @ Ts2 @ C @ Ts4 )
           => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
              & ( ( len @ regular_regular @ V @ Ts4 @ C )
                = ( ext @ product_unit @ V ) )
              & ( ( restrict @ V @ ( res @ Ts4 ) @ C )
                = ( lan @ product_unit @ V ) )
              & ( ( nat_card @ ( lan @ product_unit @ V ) )
                = ( one_one @ nat ) ) ) ) )
      = ( ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext @ product_unit @ V ) )
          & ( ( restrict @ V @ ( res @ Ts2 ) @ C )
            = ( lan @ product_unit @ V ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) ) )
        | ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V ) ) )
          & ( ( len @ regular_regular @ V @ Ts2 @ C )
            = ( ext @ product_unit @ V ) )
          & ( ( restrict @ V @ ( clm @ Ts2 ) @ C )
            = ( lan @ product_unit @ V ) )
          & ( ( nat_card @ ( lan @ product_unit @ V ) )
            = ( one_one @ nat ) ) ) ) ) ).

% hmlsl_regular.reservation
thf(fact_112_hmlsl_Oext__eq__len__eq,axiom,
    ! [V2: view_ext @ product_unit,V3: view_ext @ product_unit,Ts: traffic,C: cars] :
      ( ( ( ( ext @ product_unit @ V2 )
          = ( ext @ product_unit @ V3 ) )
        & ( ( own @ product_unit @ V2 )
          = ( own @ product_unit @ V3 ) ) )
     => ( ( len @ regular_regular @ V2 @ Ts @ C )
        = ( len @ regular_regular @ V3 @ Ts @ C ) ) ) ).

% hmlsl.ext_eq_len_eq
thf(fact_113_view_Ohorizontal__chop__own__trans,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( own @ product_unit @ U4 )
        = ( own @ product_unit @ W3 ) ) ) ).

% view.horizontal_chop_own_trans
thf(fact_114_view_Overtical__chop__own__trans,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ( own @ product_unit @ U4 )
        = ( own @ product_unit @ W3 ) ) ) ).

% view.vertical_chop_own_trans
thf(fact_115_restriction_Orestrict__subseteq,axiom,
    ! [V2: view_ext @ product_unit,F: cars > nat_int,C: cars] : ( ord_less_eq @ nat_int @ ( restrict @ V2 @ F @ C ) @ ( F @ C ) ) ).

% restriction.restrict_subseteq
thf(fact_116_restriction_Orestrict__view,axiom,
    ! [V2: view_ext @ product_unit,F: cars > nat_int,C: cars] : ( ord_less_eq @ nat_int @ ( restrict @ V2 @ F @ C ) @ ( lan @ product_unit @ V2 ) ) ).

% restriction.restrict_view
thf(fact_117_restriction_Orestrict__res,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars] : ( ord_less_eq @ nat_int @ ( restrict @ V2 @ ( res @ Ts ) @ C ) @ ( res @ Ts @ C ) ) ).

% restriction.restrict_res
thf(fact_118_restriction_Orestriction__stable,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( restrict @ U4 @ F @ C )
        = ( restrict @ W3 @ F @ C ) ) ) ).

% restriction.restriction_stable
thf(fact_119_restriction_Orestriction__stable1,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( restrict @ V2 @ F @ C )
        = ( restrict @ U4 @ F @ C ) ) ) ).

% restriction.restriction_stable1
thf(fact_120_restriction_Orestriction__stable2,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( hchop @ V2 @ U4 @ W3 )
     => ( ( restrict @ V2 @ F @ C )
        = ( restrict @ W3 @ F @ C ) ) ) ).

% restriction.restriction_stable2
thf(fact_121_restriction_Orestrict__clm,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars] : ( ord_less_eq @ nat_int @ ( restrict @ V2 @ ( clm @ Ts ) @ C ) @ ( clm @ Ts @ C ) ) ).

% restriction.restrict_clm
thf(fact_122_restriction_Orestriction__mon2,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq @ nat_int @ ( restrict @ W3 @ F @ C ) @ ( restrict @ V2 @ F @ C ) ) ) ).

% restriction.restriction_mon2
thf(fact_123_restriction_Orestriction__mon1,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq @ nat_int @ ( restrict @ U4 @ F @ C ) @ ( restrict @ V2 @ F @ C ) ) ) ).

% restriction.restriction_mon1
thf(fact_124_restriction_Orestriction__eq__view__card,axiom,
    ! [V2: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( ( restrict @ V2 @ F @ C )
        = ( lan @ product_unit @ V2 ) )
     => ( ( nat_card @ ( restrict @ V2 @ F @ C ) )
        = ( nat_card @ ( lan @ product_unit @ V2 ) ) ) ) ).

% restriction.restriction_eq_view_card
thf(fact_125_restriction_Orestrict__eq__lan__subs,axiom,
    ! [V2: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( ( ( nat_card @ ( restrict @ V2 @ F @ C ) )
          = ( nat_card @ ( lan @ product_unit @ V2 ) ) )
        & ( ord_less_eq @ nat_int @ ( restrict @ V2 @ F @ C ) @ ( lan @ product_unit @ V2 ) ) )
     => ( ( restrict @ V2 @ F @ C )
        = ( lan @ product_unit @ V2 ) ) ) ).

% restriction.restrict_eq_lan_subs
thf(fact_126_restriction_Orestriction__card__mon1,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq @ nat @ ( nat_card @ ( restrict @ U4 @ F @ C ) ) @ ( nat_card @ ( restrict @ V2 @ F @ C ) ) ) ) ).

% restriction.restriction_card_mon1
thf(fact_127_restriction_Orestriction__card__mon2,axiom,
    ! [V2: view_ext @ product_unit,U4: view_ext @ product_unit,W3: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( vchop @ V2 @ U4 @ W3 )
     => ( ord_less_eq @ nat @ ( nat_card @ ( restrict @ W3 @ F @ C ) ) @ ( nat_card @ ( restrict @ V2 @ F @ C ) ) ) ) ).

% restriction.restriction_card_mon2
thf(fact_128_restriction_Orestriction__clm__leq__one,axiom,
    ! [V2: view_ext @ product_unit,Ts: traffic,C: cars] : ( ord_less_eq @ nat @ ( nat_card @ ( restrict @ V2 @ ( clm @ Ts ) @ C ) ) @ ( one_one @ nat ) ) ).

% restriction.restriction_clm_leq_one
thf(fact_129_restriction_Orestriction__card__mon__trans,axiom,
    ! [V2: view_ext @ product_unit,V1: view_ext @ product_unit,V22: view_ext @ product_unit,V33: view_ext @ product_unit,V42: view_ext @ product_unit,F: cars > nat_int,C: cars] :
      ( ( ( vchop @ V2 @ V1 @ V22 )
        & ( vchop @ V22 @ V33 @ V42 )
        & ( ( nat_card @ ( restrict @ V33 @ F @ C ) )
          = ( one_one @ nat ) ) )
     => ( ord_less_eq @ nat @ ( one_one @ nat ) @ ( nat_card @ ( restrict @ V2 @ F @ C ) ) ) ) ).

% restriction.restriction_card_mon_trans
thf(fact_130_hmlsl__regular_Obackwards__res__stab,axiom,
    ! [Ts: traffic,D2: cars,Ts6: traffic,C: cars,V2: view_ext @ product_unit] :
      ( ( ( create_reservation @ Ts @ D2 @ Ts6 )
        & ( D2 != C )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts6 @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts6 ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V2 ) ) )
        & ( ( len @ regular_regular @ V2 @ Ts @ C )
          = ( ext @ product_unit @ V2 ) )
        & ( ( restrict @ V2 @ ( res @ Ts ) @ C )
          = ( lan @ product_unit @ V2 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V2 ) )
          = ( one_one @ nat ) ) ) ) ).

% hmlsl_regular.backwards_res_stab
thf(fact_131_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ N @ ( one_one @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% less_one
thf(fact_132_le0,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% le0
thf(fact_133_bot__nat__0_Oextremum,axiom,
    ! [A2: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ A2 ) ).

% bot_nat_0.extremum
thf(fact_134_card__non__empty__geq__one,axiom,
    ! [I: nat_int] :
      ( ( I
       != ( bot_bot @ nat_int ) )
      = ( ord_less_eq @ nat @ ( one_one @ nat ) @ ( nat_card @ I ) ) ) ).

% card_non_empty_geq_one
thf(fact_135_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A2: nat] :
      ( ( A2
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ A2 ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_136_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_nat_zero_code
thf(fact_137_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_138_infinite__descent__measure,axiom,
    ! [A: $tType,P: A > $o,V7: A > nat,X3: A] :
      ( ! [X4: A] :
          ( ~ ( P @ X4 )
         => ? [Y2: A] :
              ( ( ord_less @ nat @ ( V7 @ Y2 ) @ ( V7 @ X4 ) )
              & ~ ( P @ Y2 ) ) )
     => ( P @ X3 ) ) ).

% infinite_descent_measure
thf(fact_139_linorder__neqE__nat,axiom,
    ! [X3: nat,Y3: nat] :
      ( ( X3 != Y3 )
     => ( ~ ( ord_less @ nat @ X3 @ Y3 )
       => ( ord_less @ nat @ Y3 @ X3 ) ) ) ).

% linorder_neqE_nat
thf(fact_140_infinite__descent,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P @ N2 )
         => ? [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N2 )
              & ~ ( P @ M2 ) ) )
     => ( P @ N ) ) ).

% infinite_descent
thf(fact_141_nat__less__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N2 )
             => ( P @ M2 ) )
         => ( P @ N2 ) )
     => ( P @ N ) ) ).

% nat_less_induct
thf(fact_142_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_143_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less @ nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_144_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_145_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_146_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_147_measure__induct__rule,axiom,
    ! [B: $tType,A: $tType] :
      ( ( wellorder @ B )
     => ! [F: A > B,P: A > $o,A2: A] :
          ( ! [X4: A] :
              ( ! [Y2: A] :
                  ( ( ord_less @ B @ ( F @ Y2 ) @ ( F @ X4 ) )
                 => ( P @ Y2 ) )
             => ( P @ X4 ) )
         => ( P @ A2 ) ) ) ).

% measure_induct_rule
thf(fact_148_measure__induct,axiom,
    ! [B: $tType,A: $tType] :
      ( ( wellorder @ B )
     => ! [F: A > B,P: A > $o,A2: A] :
          ( ! [X4: A] :
              ( ! [Y2: A] :
                  ( ( ord_less @ B @ ( F @ Y2 ) @ ( F @ X4 ) )
                 => ( P @ Y2 ) )
             => ( P @ X4 ) )
         => ( P @ A2 ) ) ) ).

% measure_induct
thf(fact_149_infinite__descent0__measure,axiom,
    ! [A: $tType,V7: A > nat,P: A > $o,X3: A] :
      ( ! [X4: A] :
          ( ( ( V7 @ X4 )
            = ( zero_zero @ nat ) )
         => ( P @ X4 ) )
     => ( ! [X4: A] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( V7 @ X4 ) )
           => ( ~ ( P @ X4 )
             => ? [Y2: A] :
                  ( ( ord_less @ nat @ ( V7 @ Y2 ) @ ( V7 @ X4 ) )
                  & ~ ( P @ Y2 ) ) ) )
       => ( P @ X3 ) ) ) ).

% infinite_descent0_measure
thf(fact_150_bot__nat__0_Oextremum__strict,axiom,
    ! [A2: nat] :
      ~ ( ord_less @ nat @ A2 @ ( zero_zero @ nat ) ) ).

% bot_nat_0.extremum_strict
thf(fact_151_infinite__descent0,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [N2: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N2 )
           => ( ~ ( P @ N2 )
             => ? [M2: nat] :
                  ( ( ord_less @ nat @ M2 @ N2 )
                  & ~ ( P @ M2 ) ) ) )
       => ( P @ N ) ) ) ).

% infinite_descent0
thf(fact_152_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( N
       != ( zero_zero @ nat ) ) ) ).

% gr_implies_not0
thf(fact_153_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_zeroE
thf(fact_154_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% not_less0
thf(fact_155_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% not_gr0
thf(fact_156_gr0I,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% gr0I
thf(fact_157_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I: nat,J: nat] :
      ( ! [I2: nat,J2: nat] :
          ( ( ord_less @ nat @ I2 @ J2 )
         => ( ord_less @ nat @ ( F @ I2 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq @ nat @ I @ J )
       => ( ord_less_eq @ nat @ ( F @ I ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_158_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( M != N )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_159_Nat_Oex__has__greatest__nat,axiom,
    ! [P: nat > $o,K: nat,B2: nat] :
      ( ( P @ K )
     => ( ! [Y4: nat] :
            ( ( P @ Y4 )
           => ( ord_less_eq @ nat @ Y4 @ B2 ) )
       => ? [X4: nat] :
            ( ( P @ X4 )
            & ! [Y2: nat] :
                ( ( P @ Y2 )
               => ( ord_less_eq @ nat @ Y2 @ X4 ) ) ) ) ) ).

% Nat.ex_has_greatest_nat
thf(fact_160_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less @ nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_161_le__eq__less__or__eq,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M3: nat,N3: nat] :
          ( ( ord_less @ nat @ M3 @ N3 )
          | ( M3 = N3 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_162_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_163_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_164_nat__less__le,axiom,
    ( ( ord_less @ nat )
    = ( ^ [M3: nat,N3: nat] :
          ( ( ord_less_eq @ nat @ M3 @ N3 )
          & ( M3 != N3 ) ) ) ) ).

% nat_less_le
thf(fact_165_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_166_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_167_le__trans,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K )
       => ( ord_less_eq @ nat @ I @ K ) ) ) ).

% le_trans
thf(fact_168_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_169_card__subset__less,axiom,
    ! [I: nat_int,I3: nat_int] :
      ( ( ord_less @ nat_int @ I @ I3 )
     => ( ord_less @ nat @ ( nat_card @ I ) @ ( nat_card @ I3 ) ) ) ).

% card_subset_less
thf(fact_170_bot__nat__0_Oextremum__uniqueI,axiom,
    ! [A2: nat] :
      ( ( ord_less_eq @ nat @ A2 @ ( zero_zero @ nat ) )
     => ( A2
        = ( zero_zero @ nat ) ) ) ).

% bot_nat_0.extremum_uniqueI
thf(fact_171_bot__nat__0_Oextremum__unique,axiom,
    ! [A2: nat] :
      ( ( ord_less_eq @ nat @ A2 @ ( zero_zero @ nat ) )
      = ( A2
        = ( zero_zero @ nat ) ) ) ).

% bot_nat_0.extremum_unique
thf(fact_172_ex__least__nat__le,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ N )
     => ( ~ ( P @ ( zero_zero @ nat ) )
       => ? [K2: nat] :
            ( ( ord_less_eq @ nat @ K2 @ N )
            & ! [I4: nat] :
                ( ( ord_less @ nat @ I4 @ K2 )
               => ~ ( P @ I4 ) )
            & ( P @ K2 ) ) ) ) ).

% ex_least_nat_le
thf(fact_173_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq @ nat @ N @ ( zero_zero @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% le_0_eq
thf(fact_174_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% less_eq_nat.simps(1)
thf(fact_175_card__subset__le,axiom,
    ! [I: nat_int,I3: nat_int] :
      ( ( ord_less_eq @ nat_int @ I @ I3 )
     => ( ord_less_eq @ nat @ ( nat_card @ I ) @ ( nat_card @ I3 ) ) ) ).

% card_subset_le
thf(fact_176_card__empty__zero,axiom,
    ( ( nat_card @ ( bot_bot @ nat_int ) )
    = ( zero_zero @ nat ) ) ).

% card_empty_zero
thf(fact_177_local_Ohmlsl_Owidth__ge,axiom,
    ! [V: view_ext @ product_unit] :
      ( ? [Va: view_ext @ product_unit] :
          ( ? [X_12: view_ext @ product_unit] : ( vchop @ V @ Va @ X_12 )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = ( plus_plus @ nat @ ( zero_zero @ nat ) @ ( one_one @ nat ) ) ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ ( nat_card @ ( lan @ product_unit @ V ) ) ) ) ).

% local.hmlsl.width_ge
thf(fact_178_traffic_Ocreate__res__subseteq2,axiom,
    ! [Ts: traffic,C: cars,Ts6: traffic] :
      ( ( create_reservation @ Ts @ C @ Ts6 )
     => ( ord_less_eq @ nat_int @ ( clm @ Ts @ C ) @ ( res @ Ts6 @ C ) ) ) ).

% traffic.create_res_subseteq2
thf(fact_179_traffic_OatMostOneClm,axiom,
    ! [Ts: traffic,C: cars] : ( ord_less_eq @ nat @ ( nat_card @ ( clm @ Ts @ C ) ) @ ( one_one @ nat ) ) ).

% traffic.atMostOneClm
thf(fact_180_traffic_OatLeastOneRes,axiom,
    ! [Ts: traffic,C: cars] : ( ord_less_eq @ nat @ ( one_one @ nat ) @ ( nat_card @ ( res @ Ts @ C ) ) ) ).

% traffic.atLeastOneRes
thf(fact_181_local_Ohmlsl_Owidth__add1,axiom,
    ! [X3: nat,Y3: nat,Ts2: traffic,V: view_ext @ product_unit] :
      ( ? [Va: view_ext @ product_unit,U: view_ext @ product_unit] :
          ( ( vchop @ V @ Va @ U )
          & ( ( nat_card @ ( lan @ product_unit @ Va ) )
            = X3 )
          & ( ( nat_card @ ( lan @ product_unit @ U ) )
            = Y3 ) )
     => ( ( nat_card @ ( lan @ product_unit @ V ) )
        = ( plus_plus @ nat @ X3 @ Y3 ) ) ) ).

% local.hmlsl.width_add1
thf(fact_182_local_Ohmlsl_Owidth__add2,axiom,
    ! [X3: nat,Y3: nat,Ts2: traffic,V: view_ext @ product_unit] :
      ( ( ( nat_card @ ( lan @ product_unit @ V ) )
        = ( plus_plus @ nat @ X3 @ Y3 ) )
     => ? [Va2: view_ext @ product_unit,U2: view_ext @ product_unit] :
          ( ( vchop @ V @ Va2 @ U2 )
          & ( ( nat_card @ ( lan @ product_unit @ Va2 ) )
            = X3 )
          & ( ( nat_card @ ( lan @ product_unit @ U2 ) )
            = Y3 ) ) ) ).

% local.hmlsl.width_add2
thf(fact_183_add__left__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A )
     => ! [A2: A,B2: A,C: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C ) )
          = ( B2 = C ) ) ) ).

% add_left_cancel
thf(fact_184_add__right__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A )
     => ! [B2: A,A2: A,C: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C @ A2 ) )
          = ( B2 = C ) ) ) ).

% add_right_cancel
thf(fact_185_add__le__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A )
     => ! [C: A,A2: A,B2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B2 ) )
          = ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% add_le_cancel_left
thf(fact_186_add__le__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A )
     => ! [A2: A,C: A,B2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B2 @ C ) )
          = ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% add_le_cancel_right
thf(fact_187_add_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.left_neutral
thf(fact_188_add_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.right_neutral
thf(fact_189_double__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ( plus_plus @ A @ A2 @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero
thf(fact_190_double__zero__sym,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ A2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero_sym
thf(fact_191_add__cancel__left__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [B2: A,A2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = A2 )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_left
thf(fact_192_add__cancel__left__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A,B2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = A2 )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_right
thf(fact_193_add__cancel__right__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( plus_plus @ A @ B2 @ A2 ) )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_left
thf(fact_194_add__cancel__right__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( plus_plus @ A @ A2 @ B2 ) )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_right
thf(fact_195_add__eq__0__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X3: A,Y3: A] :
          ( ( ( plus_plus @ A @ X3 @ Y3 )
            = ( zero_zero @ A ) )
          = ( ( X3
              = ( zero_zero @ A ) )
            & ( Y3
              = ( zero_zero @ A ) ) ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_196_zero__eq__add__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X3: A,Y3: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ X3 @ Y3 ) )
          = ( ( X3
              = ( zero_zero @ A ) )
            & ( Y3
              = ( zero_zero @ A ) ) ) ) ) ).

% zero_eq_add_iff_both_eq_0
thf(fact_197_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A )
     => ! [C: A,A2: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B2 ) )
          = ( ord_less @ A @ A2 @ B2 ) ) ) ).

% add_less_cancel_left
thf(fact_198_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A )
     => ! [A2: A,C: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B2 @ C ) )
          = ( ord_less @ A @ A2 @ B2 ) ) ) ).

% add_less_cancel_right
thf(fact_199_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        & ( N
          = ( zero_zero @ nat ) ) ) ) ).

% add_is_0
thf(fact_200_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% Nat.add_0_right
thf(fact_201_nat__add__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% nat_add_left_cancel_less
thf(fact_202_nat__add__left__cancel__le,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% nat_add_left_cancel_le
thf(fact_203_add__le__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ B2 @ A2 ) @ B2 )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_le_same_cancel1
thf(fact_204_add__le__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ B2 ) @ B2 )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_le_same_cancel2
thf(fact_205_le__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( plus_plus @ A @ A2 @ B2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ B2 ) ) ) ).

% le_add_same_cancel1
thf(fact_206_le__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( plus_plus @ A @ B2 @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ B2 ) ) ) ).

% le_add_same_cancel2
thf(fact_207_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_le_zero_iff_single_add_le_zero
thf(fact_208_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_le_double_add_iff_zero_le_single_add
thf(fact_209_add__less__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ B2 @ A2 ) @ B2 )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel1
thf(fact_210_add__less__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ B2 ) @ B2 )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel2
thf(fact_211_less__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ A2 @ B2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B2 ) ) ) ).

% less_add_same_cancel1
thf(fact_212_less__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ B2 @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B2 ) ) ) ).

% less_add_same_cancel2
thf(fact_213_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_less_zero_iff_single_add_less_zero
thf(fact_214_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_less_double_add_iff_zero_less_single_add
thf(fact_215_add__gr__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( plus_plus @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        | ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% add_gr_0
thf(fact_216_add__leE,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ~ ( ( ord_less_eq @ nat @ M @ N )
         => ~ ( ord_less_eq @ nat @ K @ N ) ) ) ).

% add_leE
thf(fact_217_le__add1,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ N @ M ) ) ).

% le_add1
thf(fact_218_le__add2,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ M @ N ) ) ).

% le_add2
thf(fact_219_add__leD1,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% add_leD1
thf(fact_220_add__leD2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ( ord_less_eq @ nat @ K @ N ) ) ).

% add_leD2
thf(fact_221_le__Suc__ex,axiom,
    ! [K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ K @ L )
     => ? [N2: nat] :
          ( L
          = ( plus_plus @ nat @ K @ N2 ) ) ) ).

% le_Suc_ex
thf(fact_222_add__le__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ K @ L )
       => ( ord_less_eq @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ L ) ) ) ) ).

% add_le_mono
thf(fact_223_add__le__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ K ) ) ) ).

% add_le_mono1
thf(fact_224_trans__le__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ I @ ( plus_plus @ nat @ J @ M ) ) ) ).

% trans_le_add1
thf(fact_225_trans__le__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ I @ ( plus_plus @ nat @ M @ J ) ) ) ).

% trans_le_add2
thf(fact_226_nat__le__iff__add,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M3: nat,N3: nat] :
        ? [K3: nat] :
          ( N3
          = ( plus_plus @ nat @ M3 @ K3 ) ) ) ) ).

% nat_le_iff_add
thf(fact_227_plus__nat_Oadd__0,axiom,
    ! [N: nat] :
      ( ( plus_plus @ nat @ ( zero_zero @ nat ) @ N )
      = N ) ).

% plus_nat.add_0
thf(fact_228_add__eq__self__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = M )
     => ( N
        = ( zero_zero @ nat ) ) ) ).

% add_eq_self_zero
thf(fact_229_add__le__imp__le__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A )
     => ! [A2: A,C: A,B2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B2 @ C ) )
         => ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% add_le_imp_le_right
thf(fact_230_add__le__imp__le__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A )
     => ! [C: A,A2: A,B2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B2 ) )
         => ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% add_le_imp_le_left
thf(fact_231_le__iff__add,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ( ( ord_less_eq @ A )
        = ( ^ [A3: A,B3: A] :
            ? [C3: A] :
              ( B3
              = ( plus_plus @ A @ A3 @ C3 ) ) ) ) ) ).

% le_iff_add
thf(fact_232_add__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B2 @ C ) ) ) ) ).

% add_right_mono
thf(fact_233_less__eqE,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ~ ! [C2: A] :
                ( B2
               != ( plus_plus @ A @ A2 @ C2 ) ) ) ) ).

% less_eqE
thf(fact_234_add__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B2 ) ) ) ) ).

% add_left_mono
thf(fact_235_add__mono,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A )
     => ! [A2: A,B2: A,C: A,D2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ C @ D2 )
           => ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B2 @ D2 ) ) ) ) ) ).

% add_mono
thf(fact_236_add__mono__thms__linordered__semiring_I1_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( ord_less_eq @ A @ K @ L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(1)
thf(fact_237_add__mono__thms__linordered__semiring_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( ord_less_eq @ A @ K @ L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(2)
thf(fact_238_add__mono__thms__linordered__semiring_I3_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less_eq @ A @ I @ J )
            & ( K = L ) )
         => ( ord_less_eq @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(3)
thf(fact_239_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A )
     => ! [A2: A,C: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B2 @ C ) )
         => ( ord_less @ A @ A2 @ B2 ) ) ) ).

% add_less_imp_less_right
thf(fact_240_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A )
     => ! [C: A,A2: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B2 ) )
         => ( ord_less @ A @ A2 @ B2 ) ) ) ).

% add_less_imp_less_left
thf(fact_241_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ord_less @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B2 @ C ) ) ) ) ).

% add_strict_right_mono
thf(fact_242_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ord_less @ A @ ( plus_plus @ A @ C @ A2 ) @ ( plus_plus @ A @ C @ B2 ) ) ) ) ).

% add_strict_left_mono
thf(fact_243_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ( strict2144017051up_add @ A )
     => ! [A2: A,B2: A,C: A,D2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less @ A @ C @ D2 )
           => ( ord_less @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B2 @ D2 ) ) ) ) ) ).

% add_strict_mono
thf(fact_244_add__mono__thms__linordered__field_I1_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( K = L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(1)
thf(fact_245_add__mono__thms__linordered__field_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( ord_less @ A @ K @ L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(2)
thf(fact_246_add__mono__thms__linordered__field_I5_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( ord_less @ A @ K @ L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(5)
thf(fact_247_less__add__eq__less,axiom,
    ! [K: nat,L: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ K @ L )
     => ( ( ( plus_plus @ nat @ M @ L )
          = ( plus_plus @ nat @ K @ N ) )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% less_add_eq_less
thf(fact_248_trans__less__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ I @ ( plus_plus @ nat @ M @ J ) ) ) ).

% trans_less_add2
thf(fact_249_trans__less__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ I @ ( plus_plus @ nat @ J @ M ) ) ) ).

% trans_less_add1
thf(fact_250_add__less__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ K ) ) ) ).

% add_less_mono1
thf(fact_251_not__add__less2,axiom,
    ! [J: nat,I: nat] :
      ~ ( ord_less @ nat @ ( plus_plus @ nat @ J @ I ) @ I ) ).

% not_add_less2
thf(fact_252_not__add__less1,axiom,
    ! [I: nat,J: nat] :
      ~ ( ord_less @ nat @ ( plus_plus @ nat @ I @ J ) @ I ) ).

% not_add_less1

% Type constructors (24)
thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__monoid__add__imp__le,axiom,
    ordere516151231imp_le @ nat ).

thf(tcon_Nat_Onat___Groups_Ostrict__ordered__ab__semigroup__add,axiom,
    strict2144017051up_add @ nat ).

thf(tcon_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add @ nat ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le @ nat ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add @ nat ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat ).

thf(tcon_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat ).

thf(tcon_Nat_Onat___Groups_Oone,axiom,
    one @ nat ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__semigroup__monoid__add__imp__le_1,axiom,
    ordere516151231imp_le @ real ).

thf(tcon_Real_Oreal___Groups_Ostrict__ordered__ab__semigroup__add_2,axiom,
    strict2144017051up_add @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__cancel__ab__semigroup__add_3,axiom,
    ordere223160158up_add @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__semigroup__add__imp__le_4,axiom,
    ordere236663937imp_le @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__semigroup__add_5,axiom,
    ordere779506340up_add @ real ).

thf(tcon_Real_Oreal___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add @ real ).

thf(tcon_Real_Oreal___Groups_Ocancel__comm__monoid__add_6,axiom,
    cancel1352612707id_add @ real ).

thf(tcon_Real_Oreal___Groups_Ocancel__semigroup__add_7,axiom,
    cancel_semigroup_add @ real ).

thf(tcon_Real_Oreal___Groups_Omonoid__add_8,axiom,
    monoid_add @ real ).

thf(tcon_Real_Oreal___Groups_Ozero_9,axiom,
    zero @ real ).

thf(tcon_Real_Oreal___Groups_Oone_10,axiom,
    one @ real ).

thf(tcon_Product__Type_Ounit___Orderings_Owellorder_11,axiom,
    wellorder @ product_unit ).

% Conjectures (2)
thf(conj_0,hypothesis,
    ! [V8: view_ext @ product_unit] :
      ( ( ( ord_less_eq @ ( view_ext @ product_unit ) @ V8 @ ( move @ ts3 @ ts @ v ) )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V8 ) ) )
        & ( ( len @ regular_regular @ V8 @ ts @ c )
          = ( ext @ product_unit @ V8 ) )
        & ( ( restrict @ V8 @ ( res @ ts ) @ c )
          = ( lan @ product_unit @ V8 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V8 ) )
          = ( one_one @ nat ) )
        & ( ord_less @ real @ ( zero_zero @ real ) @ ( real_length @ ( ext @ product_unit @ V8 ) ) )
        & ( ( len @ regular_regular @ V8 @ ts @ e )
          = ( ext @ product_unit @ V8 ) )
        & ( ( restrict @ V8 @ ( res @ ts ) @ e )
          = ( lan @ product_unit @ V8 ) )
        & ( ( nat_card @ ( lan @ product_unit @ V8 ) )
          = ( one_one @ nat ) ) )
     => thesis ) ).

thf(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
